#include <iostream>
#include <algorithm>
#include <cmath>

using namespace std;

const int maxn = 1000;

struct Tacke 
{
    int x, y;
};

int n;
Tacke tackice[maxn];

int orj(Tacke p, Tacke q, Tacke r) 
{
    return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
}

int povrsina(Tacke pl[], int n) 
{
    int p = 0;
    for (int i = 0; i < n; i++) 
    {
        int j = (i + 1) % n;
        p += pl[i].x * pl[j].y;
        p -= pl[j].x * pl[i].y;
    }
    return abs(p) / 2;
}

int om(Tacke tackice[], int n, Tacke r[]) 
{
    sort(tackice, tackice + n, [](const Tacke &a, const Tacke &b) 
    {
        if (a.x != b.x) return a.x < b.x;
        return a.y < b.y;
    });

    int m = 0;

    for (int i = 0; i < n; i++) 
    {
        while (m >= 2 && orj(r[m - 2], r[m - 1], tackice[i]) <= 0) 
        {
            m--;
        }
        r[m++] = tackice[i];
    }

    int t = m + 1;
    for (int i = n - 2; i >= 0; i--) 
    {
        while (m >= t && orj(r[m - 2], r[m - 1], tackice[i]) <= 0) 
        {
            m--;
        }
        r[m++] = tackice[i];
    }

    return m - 1;
}

int main() 
{
    cin >> n;

    for (int i = 0; i < n; i++) 
    {
        cin >> tackice[i].x >> tackice[i].y;
    }

    Tacke a[maxn];

    int s = om(tackice, n, a);

    int minimum = INT_MAX;

    for (int i = 0; i < s; i++) 
    {
        Tacke rt[maxn];
        int rn = 0;
        for (int j = 0; j < n; j++) 
        {
            if (j != i) 
            {
                rt[rn++] = tackice[j];
            }
        }
        Tacke rh[maxn];
        int rhs = om(rt, rn, rh);

        int povrs = povrsina(rh, rhs);
        minimum = min(minimum, povrs);
    }

    cout << minimum << endl;

    return 0;
}